/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */



#pragma once

// Build this structure so that we can use it in the outside
// world.

typedef struct Msg_ent {
	short msg_type;				/* message type */
	short msg_line1;			/* starting line */
	short msg_col1;				/* starting column */
	short msg_line2;			/* ending line */
	short msg_col2;				/* ending column */
	short msg_num;				/* message number (for stable sort) */
	char *msg_text;				/* message text */
	short msg_lineno1;			/* line number in listing where this message starts */
	short msg_lineno2;			/* line number in listing where this message ends */
	struct Msg_ent *msg_prev;	/* link to previous message */
} Msg_ent, *Msg;


int merge_error_source(Handle text,  char *msgfilename,
	char *listfilename, Msg **ptr);

void	free_msg(int errors, Msg *ptr);
